VERSION ("Reader 1.0")

'**********************************************************************************************************************
'
'  Sample Program for Reader Commands
'
'  Target Machine : CPT-711
'
'  Commands :
' 	ENABLE READER(N%) : To enable the reader ports of the terminal.
'                                                  "N% is 1 for terminals 711and 720.
'
'	ON READER...GOSUB... : To activate the "READER Event Trigger which executes a specific 
'                                                    subroutine when data is received from the reader ports.
'
'	OFF READER(N%) : To terminate the "READER Event Trigger which executes a specific
'                                           subroutine when data is received from the reader ports.
'
'	A$ = GET_READER_DATA$ (N%) : To get the data read from the specified reader port.
'                                                                  "A$ is a string variable to be assigned with the result.
'    					       "N% is 1 for terminals 711and 720.
'
'	A% = CODE_TYPE : To get the type of symbology being decoded upon a successful scan.
'                                            "A% is an integer variable to be assigned with the result.
'
'**********************************************************************************************************************


	CLS
	LOCATE 1,4 
            PRINT "[ READER TEST ]"

	LOCATE 3,1 
	PRINT "CODE:"

	LOCATE 5,1 
	PRINT "TYPE:"

	LOCATE 7,1 
	PRINT "LEN :"

 	ENABLE READER(1)

MainStart:
	ON READER(1) GOSUB GetBcrData

	IF BcrData$ <> "" THEN
		FOR i% =3 TO 7 STEP 2
			LOCATE i%,6
			PRINT STRING$(12, " ")
		NEXT i%

		LOCATE 3,6
		PRINT "                                "

		LOCATE 3,6
		PRINT BcrData$

		LOCATE 5,6
		PRINT BcrType$

		LOCATE 7,6
		PRINT BcrLen%

		BcrData$ = ""	
	END IF
	GOTO MainStart


GetBcrData:

	OFF READER(1)
	BEEP(2000,5)

	BcrData$ = GET_READER_DATA$(1)
	BcrLen% = LEN(BcrData$)

	GOTO CheckBcrType
	RETURN


CheckBcrType:

	Type% = CODE_TYPE

	IF Type% = 65 THEN
		BcrType$ = "Code 39"
	ELSE IF Type% = 66 THEN
		BcrType$ = "Italy Pharma-code"
	ELSE IF Type% = 67 THEN
		BcrType$ = "CIP 39"
	ELSE IF Type% = 68 THEN
		BcrType$ = "Industrial 25"
	ELSE IF Type% = 69 THEN
		BcrType$ = "Interleave 25"
	ELSE IF Type% = 70 THEN
		BcrType$ = "Matrix 25"
	ELSE IF Type% = 71 THEN
		BcrType$ = "Codabar (NW7)"
	ELSE IF Type% = 72 THEN
		BcrType$ = "Code 93"
	ELSE IF Type% = 73 THEN
		BcrType$ = "Code128"
	ELSE IF Type% = 74 THEN
		BcrType$ = "UPCE no Addon"
	ELSE IF Type% = 75 THEN
		BcrType$ = "UPCE with Addon 2"
	ELSE IF Type% = 76 THEN
		BcrType$ = "UPCE with Addon 5"
	ELSE IF Type% = 77 THEN
		BcrType$ = "EAN8 no Addon"
	ELSE IF Type% = 78 THEN
		BcrType$ = "EAN8 with Addon 2"
	ELSE IF Type% = 79 THEN
		BcrType$ = "EAN8 with Addon 5"
	ELSE IF Type% = 80 THEN
		BcrType$ = "EAN13 no Addon"
	ELSE IF Type% = 81 THEN
		BcrType$ = "EAN13 with Addon 2"
	ELSE IF Type% = 82 THEN
		BcrType$ = "EAN13 with Addon 5"
	ELSE IF Type% = 83 THEN
		BcrType$ = "MSI"
	ELSE IF Type% = 84 THEN
		BcrType$ = "Plessey"
	ELSE IF Type% = 85 THEN
		BcrType$ = "Code ABC"
	ELSE IF Type% = 97 THEN
		BcrType$ = "ISO Track 1"
	ELSE IF Type% = 98 THEN
		BcrType$ = "ISO Track 2"
	ELSE IF Type% = 99 THEN
		BcrType$ = "ISO Track 1 and 2"
	ELSE IF Type% = 100 THEN
		BcrType$ = "ISO Track 2 and 3"
	ELSE IF Type% = 101 THEN
		BcrType$ = "JIS II"
	ELSE
		BcrType$ = "Other Barcode Kind"
	END IF
	RETURN
	
	